/*
 * Decompiled with CFR 0.152.
 */
package com.dfdyz.epicacg.registry;

import com.dfdyz.epicacg.efmextra.skills.EpicACGSkillSlot;
import com.dfdyz.epicacg.efmextra.weapon.GenShinBow;
import com.dfdyz.epicacg.efmextra.weapon.WeaponCollider;
import com.dfdyz.epicacg.registry.MyAnimations;
import com.dfdyz.epicacg.registry.MySkills;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TieredItem;
import org.slf4j.Logger;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.forgeevent.WeaponCapabilityPresetRegistryEvent;
import yesman.epicfight.api.utils.ExtendableEnum;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.ColliderPreset;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.item.WeaponCapability;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public class WeaponTypes {
    public static final Function<Item, CapabilityItem.Builder> GENSHIN_BOW = item -> {
        WeaponCapability.Builder builder = (WeaponCapability.Builder)WeaponCapability.builder().category((WeaponCategory)CapabilityItem.WeaponCategories.RANGED).styleProvider(playerpatch -> CapabilityItem.Styles.ONE_HAND).collider(WeaponCollider.GenShin_Bow_scan).swingSound((SoundEvent)EpicFightSounds.WHOOSH_BIG.get()).hitSound((SoundEvent)EpicFightSounds.BLADE_HIT.get()).canBePlacedOffhand(false).passiveSkill(MySkills.GS_Bow_Internal).newStyleCombo((Style)CapabilityItem.Styles.ONE_HAND, new StaticAnimation[]{MyAnimations.GS_Yoimiya_Auto1, MyAnimations.GS_Yoimiya_Auto2, MyAnimations.GS_Yoimiya_Auto3, MyAnimations.GS_Yoimiya_Auto4, MyAnimations.GS_Yoimiya_Auto5, MyAnimations.GS_Yoimiya_Auto2, MyAnimations.GS_Yoimiya_FallAtk_Start}).innateSkill((Style)CapabilityItem.Styles.ONE_HAND, itemStack -> MySkills.GS_YOIMIYA_SPECIALATK).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.IDLE, Animations.BIPED_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.WALK, Animations.BIPED_WALK).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.RUN, Animations.BIPED_RUN).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.JUMP, Animations.BIPED_JUMP).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.KNEEL, Animations.BIPED_KNEEL).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.SNEAK, Animations.BIPED_SNEAK).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.SWIM, Animations.BIPED_SWIM).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.AIM, Animations.BIPED_BOW_AIM).livingMotionModifier((Style)CapabilityItem.Styles.ONE_HAND, (LivingMotion)LivingMotions.BLOCK, Animations.BIPED_BLOCK).constructor(GenShinBow::new);
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> GENSHIN_SPEAR = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category((WeaponCategory)EpicACGWeaponCategories.GS_SPEAR).styleProvider(playerpatch -> CapabilityItem.Styles.COMMON).collider(ColliderPreset.LONGSWORD).hitSound((SoundEvent)EpicFightSounds.BLADE_HIT.get()).newStyleCombo((Style)CapabilityItem.Styles.COMMON, new StaticAnimation[]{MyAnimations.GS_LAODENG_AUTO1, MyAnimations.GS_LAODENG_AUTO2, MyAnimations.GS_LAODENG_AUTO3, MyAnimations.GS_LAODENG_AUTO4, MyAnimations.GS_LAODENG_AUTO5, MyAnimations.GS_LAODENG_AUTO6, Animations.SPEAR_DASH, Animations.SPEAR_TWOHAND_AIR_SLASH}).innateSkill((Style)CapabilityItem.Styles.COMMON, itemStack -> MySkills.BATTLE_SCYTHE_SA).livingMotionModifier((Style)CapabilityItem.Styles.COMMON, (LivingMotion)LivingMotions.BLOCK, Animations.SWORD_GUARD).livingMotionModifier((Style)CapabilityItem.Styles.COMMON, (LivingMotion)LivingMotions.IDLE, MyAnimations.SAO_SCYTHE_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.COMMON, (LivingMotion)LivingMotions.WALK, MyAnimations.SAO_SCYTHE_WALK).livingMotionModifier((Style)CapabilityItem.Styles.COMMON, (LivingMotion)LivingMotions.RUN, MyAnimations.SAO_SCYTHE_RUN).weaponCombinationPredicator(entitypatch -> false);
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> BATTLE_SCYTHE = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category((WeaponCategory)EpicACGWeaponCategories.SCYTHE).styleProvider(playerpatch -> CapabilityItem.Styles.TWO_HAND).collider(ColliderPreset.LONGSWORD).hitSound((SoundEvent)EpicFightSounds.BLADE_HIT.get()).newStyleCombo((Style)CapabilityItem.Styles.TWO_HAND, new StaticAnimation[]{MyAnimations.BATTLE_SCYTHE_AUTO1, MyAnimations.BATTLE_SCYTHE_AUTO2, MyAnimations.BATTLE_SCYTHE_AUTO3, MyAnimations.BATTLE_SCYTHE_AUTO4, MyAnimations.BATTLE_SCYTHE_AUTO5, MyAnimations.BATTLE_SCYTHE_DASH, Animations.SPEAR_TWOHAND_AIR_SLASH}).innateSkill((Style)CapabilityItem.Styles.TWO_HAND, itemStack -> MySkills.BATTLE_SCYTHE_SA).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.BLOCK, Animations.SWORD_GUARD).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.IDLE, MyAnimations.SAO_SCYTHE_IDLE).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.WALK, MyAnimations.SAO_SCYTHE_WALK).livingMotionModifier((Style)CapabilityItem.Styles.TWO_HAND, (LivingMotion)LivingMotions.RUN, MyAnimations.SAO_SCYTHE_RUN).weaponCombinationPredicator(entitypatch -> false);
        return builder;
    };
    public static final Function<Item, CapabilityItem.Builder> SAO_SINGLE_SWORD = item -> {
        WeaponCapability.Builder builder = WeaponCapability.builder().category((WeaponCategory)EpicACGWeaponCategories.SINGLE_SWORD).styleProvider(playerpatch -> {
            if (playerpatch instanceof PlayerPatch) {
                if (playerpatch.getHoldingItemCapability(InteractionHand.OFF_HAND).getWeaponCategory() == EpicACGWeaponCategories.SINGLE_SWORD && ((PlayerPatch)playerpatch).getSkill((SkillSlot)EpicACGSkillSlot.SAO_SINGLE_SWORD).getSkill() != null && ((PlayerPatch)playerpatch).getSkill((SkillSlot)EpicACGSkillSlot.SAO_SINGLE_SWORD).getSkill().getRegistryName().m_135815_().equals("sao_dual_sword_skill")) {
                    return EpicACGStyles.SAO_DUAL_SWORD;
                }
                if (((PlayerPatch)playerpatch).getSkill((SkillSlot)EpicACGSkillSlot.SAO_SINGLE_SWORD).getSkill() != null && ((PlayerPatch)playerpatch).getSkill((SkillSlot)EpicACGSkillSlot.SAO_SINGLE_SWORD).getSkill().getRegistryName().m_135815_().equals("sao_rapier_skill")) {
                    return EpicACGStyles.SAO_RAPIER;
                }
            } else if (playerpatch instanceof HumanoidMobPatch) {
                Set tags = ((LivingEntity)playerpatch.getOriginal()).m_19880_();
                Iterator iterator = tags.iterator();
                if (iterator.hasNext()) {
                    String tag = (String)iterator.next();
                    String[] arg = tag.split(":");
                    if (arg.length > 2 && arg[0] == "epicacg" && arg[1] == "sao_single_sword") {
                        switch (arg[3]) {
                            case "dual_sword": {
                                return EpicACGStyles.SAO_DUAL_SWORD;
                            }
                            case "rapier": {
                                return EpicACGStyles.SAO_RAPIER;
                            }
                        }
                        return EpicACGStyles.SAO_SINGLE_SWORD;
                    }
                    return CapabilityItem.Styles.ONE_HAND;
                }
                return EpicACGStyles.SAO_SINGLE_SWORD;
            }
            return EpicACGStyles.SAO_SINGLE_SWORD;
        }).passiveSkill(MySkills.SAO_SINGLESWORD_INTERNAL).collider(WeaponCollider.SAO_SWORD).hitSound((SoundEvent)EpicFightSounds.BLADE_HIT.get()).newStyleCombo((Style)EpicACGStyles.SAO_SINGLE_SWORD, new StaticAnimation[]{Animations.SWORD_AUTO1, Animations.SWORD_AUTO2, Animations.SWORD_AUTO3, Animations.SWORD_DASH, Animations.SWORD_DASH, Animations.SWORD_AIR_SLASH}).newStyleCombo((Style)EpicACGStyles.SAO_RAPIER, new StaticAnimation[]{MyAnimations.SAO_RAPIER_AUTO1, MyAnimations.SAO_RAPIER_AUTO2, MyAnimations.SAO_RAPIER_AUTO3, MyAnimations.SAO_RAPIER_AUTO4, MyAnimations.SAO_RAPIER_AUTO5, MyAnimations.SAO_RAPIER_DASH, MyAnimations.SAO_RAPIER_DASH, MyAnimations.SAO_RAPIER_AIR}).newStyleCombo((Style)EpicACGStyles.SAO_DUAL_SWORD, new StaticAnimation[]{MyAnimations.SAO_DUAL_SWORD_AUTO1, MyAnimations.SAO_DUAL_SWORD_AUTO2, MyAnimations.SAO_DUAL_SWORD_AUTO3, MyAnimations.SAO_DUAL_SWORD_AUTO4, MyAnimations.SAO_DUAL_SWORD_AUTO5, MyAnimations.SAO_DUAL_SWORD_AUTO6, MyAnimations.SAO_DUAL_SWORD_AUTO7, MyAnimations.SAO_DUAL_SWORD_AUTO8, MyAnimations.SAO_DUAL_SWORD_AUTO9, MyAnimations.SAO_DUAL_SWORD_AUTO10, MyAnimations.SAO_DUAL_SWORD_AUTO11, MyAnimations.SAO_DUAL_SWORD_AUTO12, MyAnimations.SAO_DUAL_SWORD_DASH, Animations.SPEAR_DASH, Animations.GREATSWORD_AIR_SLASH}).innateSkill((Style)EpicACGStyles.SAO_SINGLE_SWORD, itemstack -> MySkills.SAO_SINGLESWORD_SA).innateSkill((Style)EpicACGStyles.SAO_DUAL_SWORD, itemstack -> MySkills.SAO_DUAL_SWORD_SA).innateSkill((Style)EpicACGStyles.SAO_RAPIER, itemstack -> MySkills.WEAPON_SKILL_RAPIER).livingMotionModifier((Style)EpicACGStyles.SAO_SINGLE_SWORD, (LivingMotion)LivingMotions.IDLE, Animations.BIPED_IDLE).livingMotionModifier((Style)EpicACGStyles.SAO_SINGLE_SWORD, (LivingMotion)LivingMotions.BLOCK, MyAnimations.SAO_SINGLE_SWORD_GUARD).livingMotionModifier((Style)EpicACGStyles.SAO_RAPIER, (LivingMotion)LivingMotions.BLOCK, MyAnimations.SAO_SINGLE_SWORD_GUARD).livingMotionModifier((Style)EpicACGStyles.SAO_RAPIER, (LivingMotion)LivingMotions.IDLE, MyAnimations.SAO_RAPIER_IDLE).livingMotionModifier((Style)EpicACGStyles.SAO_RAPIER, (LivingMotion)LivingMotions.WALK, MyAnimations.SAO_RAPIER_WALK).livingMotionModifier((Style)EpicACGStyles.SAO_RAPIER, (LivingMotion)LivingMotions.RUN, MyAnimations.SAO_RAPIER_RUN).livingMotionModifier((Style)EpicACGStyles.SAO_RAPIER, (LivingMotion)LivingMotions.KNEEL, MyAnimations.SAO_RAPIER_IDLE).livingMotionModifier((Style)EpicACGStyles.SAO_DUAL_SWORD, (LivingMotion)LivingMotions.IDLE, MyAnimations.SAO_DUAL_SWORD_HOLD).livingMotionModifier((Style)EpicACGStyles.SAO_DUAL_SWORD, (LivingMotion)LivingMotions.WALK, MyAnimations.SAO_DUAL_SWORD_WALK).livingMotionModifier((Style)EpicACGStyles.SAO_DUAL_SWORD, (LivingMotion)LivingMotions.CHASE, MyAnimations.SAO_DUAL_SWORD_HOLD).livingMotionModifier((Style)EpicACGStyles.SAO_DUAL_SWORD, (LivingMotion)LivingMotions.RUN, MyAnimations.SAO_DUAL_SWORD_RUN).livingMotionModifier((Style)EpicACGStyles.SAO_DUAL_SWORD, (LivingMotion)LivingMotions.JUMP, MyAnimations.SAO_DUAL_SWORD_NORMAL).livingMotionModifier((Style)EpicACGStyles.SAO_DUAL_SWORD, (LivingMotion)LivingMotions.KNEEL, MyAnimations.SAO_RAPIER_IDLE).livingMotionModifier((Style)EpicACGStyles.SAO_DUAL_SWORD, (LivingMotion)LivingMotions.SWIM, MyAnimations.SAO_DUAL_SWORD_NORMAL).livingMotionModifier((Style)EpicACGStyles.SAO_DUAL_SWORD, (LivingMotion)LivingMotions.BLOCK, Animations.SWORD_DUAL_GUARD).weaponCombinationPredicator(entitypatch -> {
            boolean tag = false;
            if (entitypatch.getHoldingItemCapability(InteractionHand.OFF_HAND).getWeaponCategory() == EpicACGWeaponCategories.SINGLE_SWORD && entitypatch instanceof PlayerPatch && ((PlayerPatch)entitypatch).getSkill((SkillSlot)EpicACGSkillSlot.SAO_SINGLE_SWORD).getSkill() != null && ((PlayerPatch)entitypatch).getSkill((SkillSlot)EpicACGSkillSlot.SAO_SINGLE_SWORD).getSkill().getRegistryName().m_135815_().equals("sao_dual_sword_skill")) {
                tag = true;
            }
            return tag;
        });
        if (item instanceof TieredItem) {
            int harvestLevel = ((TieredItem)item).m_43314_().m_6604_();
            builder.addStyleAttibutes((Style)CapabilityItem.Styles.COMMON, Pair.of((Object)((Attribute)EpicFightAttributes.IMPACT.get()), (Object)EpicFightAttributes.getImpactModifier((double)(0.5 + 0.2 * (double)harvestLevel))));
            builder.addStyleAttibutes((Style)CapabilityItem.Styles.COMMON, Pair.of((Object)((Attribute)EpicFightAttributes.MAX_STRIKES.get()), (Object)EpicFightAttributes.getMaxStrikesModifier((int)1)));
        }
        return builder;
    };

    public static void register(WeaponCapabilityPresetRegistryEvent event) {
        Logger LOGGER = LogUtils.getLogger();
        LOGGER.info("Loading WeaponCapability");
        event.getTypeEntry().put(new ResourceLocation("epicacg", "sao_single_sword"), SAO_SINGLE_SWORD);
        event.getTypeEntry().put(new ResourceLocation("epicacg", "genshin_bow"), GENSHIN_BOW);
        event.getTypeEntry().put(new ResourceLocation("epicacg", "battle_scythe"), BATTLE_SCYTHE);
        event.getTypeEntry().put(new ResourceLocation("epicacg", "gs_spear"), GENSHIN_SPEAR);
        LOGGER.info("WeaponCapability Loaded");
    }

    public static enum EpicACGWeaponCategories implements WeaponCategory
    {
        SCYTHE,
        SINGLE_SWORD,
        LONG_SWORD,
        GS_SPEAR;

        final int id = WeaponCategory.ENUM_MANAGER.assign((ExtendableEnum)this);

        public int universalOrdinal() {
            return this.id;
        }
    }

    public static enum EpicACGStyles implements Style
    {
        SAO_DUAL_SWORD(true),
        SAO_SINGLE_SWORD(true),
        SAO_RAPIER(true);

        final boolean canUseOffhand;
        final int id = Style.ENUM_MANAGER.assign((ExtendableEnum)this);

        private EpicACGStyles(boolean canUseOffhand) {
            this.canUseOffhand = canUseOffhand;
        }

        public int universalOrdinal() {
            return this.id;
        }

        public boolean canUseOffhand() {
            return this.canUseOffhand;
        }
    }
}

